<?php
class Loadlink_Shipping_Method extends WC_Shipping_Method {
    public function __construct($instance_id = 0) {
        $this->id                 = 'loadlink_rates';
        $this->instance_id        = absint($instance_id);
        $this->method_title       = __('Loadlink Parcel Freight Live Rates', 'loadlink');
        $this->method_description = __('Get real-time shipping rates from Loadlink Parcel Freight.', 'loadlink');
        $this->supports           = array(
            'shipping-zones',
            'instance-settings',
            'instance-settings-modal'
        );
    
        $this->enabled = 'yes';
        $this->title   = __('Loadlink Parcel Freight Shipping', 'loadlink');
    
        $this->init();
    }


    public function init() {
        $this->init_form_fields();
        $this->init_settings();
    
        add_action('woocommerce_update_options_shipping_' . $this->id . '_' . $this->instance_id, [$this, 'process_admin_options']);
    }

    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array(
                'title'       => __('Enable/Disable', 'loadlink'),
                'type'        => 'checkbox',
                'label'       => __('Enable Loadlink Parcel Freight Live Rates for this zone', 'loadlink'),
                'default'     => 'yes',
            ),
            'title' => array(
                'title'       => __('Method Title', 'loadlink'),
                'type'        => 'text',
                'description' => __('Title shown to customers at checkout', 'loadlink'),
                'default'     => __('Loadlink Parcel Freight Shipping', 'loadlink'),
            ),
            'fallback_cost' => [
                'title'       => __('Fallback Cost', 'loadlink'),
                'type'        => 'price',
                'description' => __('Default cost applied when Loadlink Parcel Freight returns no rates', 'loadlink'),
                'default'     => '25',
            ],
        );
    }

    /*public function calculate_shipping($package = []) {
        $rates = Loadlink_Rates_Controller::get_rates($package);
        foreach ($rates as $rate) {
            $this->add_rate($rate);
        }
        
        // Store freight data in session for order confirmation
        $this->store_freight_data_in_session();
    }*/
    public function calculate_shipping($package = []) {

        // Request live rates from Loadlink
        $rates = Loadlink_Rates_Controller::get_rates($package);
    
        if (!empty($rates) && is_array($rates)) {
            // Add all live rates
            foreach ($rates as $rate) {
                $this->add_rate($rate);
            }
    
            // Store freight data in session for later use
            $this->store_freight_data_in_session();
    
        } else {
            /**
             * -------------------------------------------------
             * Fallback: Apply default flat rate
             * -------------------------------------------------
             */
            Loadlink_Logger::log('No live rates returned - applying fallback rate', 'warning');
    
            $this->add_rate([
                'id'    => $this->id . '_fallback',
                'label' => __('Standard Freight (Default Rate)', 'loadlink'),
                'cost'  => (float) $this->get_option('fallback_cost', 25),
                'meta_data' => [
                    'source' => 'fallback',
                    'note'   => 'Minimum weight or API unavailable'
                ]
            ]);
        }
    }

    
    private function store_freight_data_in_session() {
        if (!function_exists('WC') || !WC()->session) {
            return;
        }
        
        // Get freight data from Loadlink_Client
        if (class_exists('Loadlink_Client')) {
            $freight_data = Loadlink_Client::get_all_freight_data();
            if (!empty($freight_data)) {
                WC()->session->set('loadlink_freight_data', $freight_data);
                Loadlink_Logger::log('Stored freight data in session: ' . json_encode($freight_data), 'debug');
            }
        }
    }
}
