<?php
/**
 * Loadlink Priority & Default Rate Handling
 * -----------------------------------------
 * - Moves Loadlink rates above Local Pickup
 * - Sets the cheapest Loadlink rate as the default
 */

if (!defined('ABSPATH')) exit;

/**
 * Sort rates: Loadlink first, Local Pickup last
 */
add_filter('woocommerce_package_rates', function($rates, $package) {

    uasort($rates, function($a, $b) {
        // Push Local Pickup to bottom
        if (strpos($a->method_id, 'local_pickup') !== false) return 1;
        if (strpos($b->method_id, 'local_pickup') !== false) return -1;
        return 0;
    });

    return $rates;

}, 20, 2);

/**
 * Pick the lowest-priced Loadlink rate as default
 */
add_filter('woocommerce_shipping_chosen_method', function($default, $rates) {

    $lowest_id = '';
    $lowest_cost = INF;

    foreach ($rates as $rate_id => $rate) {
        if (strpos($rate->method_id, 'loadlink_rates') !== false) {
            if ($rate->cost < $lowest_cost) {
                $lowest_cost = $rate->cost;
                $lowest_id   = $rate_id;
            }
        }
    }

    return $lowest_id ?: $default;

}, 10, 2);
