<?php
class Loadlink_Shipping_Method extends WC_Shipping_Method {
    public function __construct() {
        $this->id = 'loadlink';
        $this->method_title = __('Loadlink Shipping', 'loadlink');
        $this->method_description = __('Live shipping rates from Loadlink.', 'loadlink');

        $this->enabled = 'yes';
        $this->title = 'Loadlink Shipping';

        $this->init();
    }

    public function init() {
        $this->init_form_fields();
        $this->init_settings();

        add_action('woocommerce_update_options_shipping_' . $this->id, [$this, 'process_admin_options']);
    }

    public function calculate_shipping($package = []) {
        $rate = [
            'id' => $this->id,
            'label' => $this->title,
            'cost' => '10.00', // placeholder
            'package' => $package
        ];
        $this->add_rate($rate);
    }
}
