<?php
/**
 * Loadlink Parcel Freight Admin Dashboard
 */

if (!defined('ABSPATH')) {
    exit;
}

class Loadlink_Admin_Dashboard {
    
    public function __construct() {
        add_action('admin_menu', [$this, 'add_admin_menu'], 5); // Priority 5 to run before other menu registrations
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_scripts']);
    }
    
    /**
     * Add main Loadlink admin menu
     */
    public function add_admin_menu() {
        // Create data URL for custom SVG icon
        $icon_svg = '<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 129.6 101.9" width="20" height="20">
  <defs>
    <style>
      .cls-1 {
        fill: #f37d48;
      }
      .cls-2 {
        fill: #1e3d5b;
      }
    </style>
  </defs>
  <g>
    <g id="Layer_1">
      <g>
        <g>
          <path class="cls-1" d="M109.9,28.8c-6.1,1.7-12.4,3.8-19,6.3l6.3,1.3c5.1-2.4,10.2-4.6,15.3-6.6l-2.7-1Z"/>
          <path class="cls-1" d="M42.1,61.2h15.3c6-4.8,12.4-9.3,19.2-13.5l-9.4-1.7c-8.5,4.5-16.8,9.6-25.1,15.3Z"/>
          <path class="cls-1" d="M124.3,25.6c-3.1.5-6.3,1.1-9.7,1.9l1.9.7c2.7-1,5.2-1.8,7.8-2.7Z"/>
          <path class="cls-1" d="M71.8,43.5l8.9,1.6c4-2.4,8.2-4.6,12.4-6.7l-6.9-1.5c-4.8,1.9-9.6,4.1-14.4,6.6Z"/>
        </g>
        <path class="cls-1" d="M35.4,66c-.5.4-.9.6-1.4,1-10.4,8-20.5,16.9-29.6,26.8h22.1c4.5-6.7,15.9-19.2,25.1-27.8,0,0-16.2,0-16.2,0Z"/>
        <path class="cls-2" d="M59.3,93.8c13.4-22.7,33-43.9,64.2-62.3-42,11.5-77.2,50.9-84.1,62.3h19.8Z"/>
        <path class="cls-2" d="M110.9,39.3c-2.8,1.8-5.5,3.7-8.1,5.6.9,2.9,1.4,6,1.4,9.2,0,17.4-14.1,31.3-31.3,31.3h-1.6c-2.2,2.8-4.2,5.7-6.2,8.7h0c2.5.6,5.1.8,7.7.8,22.6,0,40.9-18.3,40.9-40.9,0-5.1-.9-10.1-2.8-14.8Z"/>
        <path class="cls-2" d="M72.8,13.3c-22.6,0-40.9,18.3-40.9,40.9v1.8c3.2-2,6.4-3.9,9.7-5.7,1.9-15.5,15.2-27.5,31.1-27.5s7.4.6,10.7,1.8l14.1-3c-6.8-5.2-15.4-8.4-24.7-8.4Z"/>
        <path class="cls-2" d="M109,25.1c-14.8,1.4-37.6,6.8-45.9,9.1-8.2,2.3-14.9,4.7-19.2,6.2-1.6,3.1-11.6,11.9-11.9,15.6,8.8-5.2,23-12.1,32.9-16.4,8.5-3.7,24.9-9.2,27.8-10,3-.9,16.4-4.6,16.4-4.6Z"/>
      </g>
    </g>
  </g>
</svg>';
        
        $icon_data_url = 'data:image/svg+xml;base64,' . base64_encode($icon_svg);
        
        // Main Loadlink menu
        add_menu_page(
            'Loadlink Parcel Freight',
            'Loadlink Parcel Freight',
            'manage_woocommerce',
            'loadlink-dashboard',
            [$this, 'display_dashboard'],
            $icon_data_url,
            30
        );
        
        // Dashboard submenu
        add_submenu_page(
            'loadlink-dashboard',
            'Dashboard',
            'Dashboard',
            'manage_woocommerce',
            'loadlink-dashboard',
            [$this, 'display_dashboard']
        );
        
        // My Parcel Freight submenu
        add_submenu_page(
            'loadlink-dashboard',
            'My Parcel Freight',
            'My Parcel Freight',
            'manage_woocommerce',
            'loadlink-freight',
            [$this, 'display_freight_page']
        );
    }
    
    /**
     * Enqueue admin scripts and styles
     */
    public function enqueue_admin_scripts($hook) {
        if (strpos($hook, 'loadlink') === false) {
            return;
        }
        
        wp_enqueue_style('loadlink-admin', LOADLINK_PLUGIN_URL . 'assets/admin-dashboard.css', [], LOADLINK_VERSION);
        
        if ($hook === 'loadlink_page_loadlink-freight') {
            wp_enqueue_style('loadlink-admin-freight', LOADLINK_PLUGIN_URL . 'assets/admin-freight.css', [], LOADLINK_VERSION);
            wp_enqueue_script('loadlink-admin-freight', LOADLINK_PLUGIN_URL . 'assets/admin-freight.js', ['jquery'], LOADLINK_VERSION, true);
            
            wp_localize_script('loadlink-admin-freight', 'loadlinkAdmin', [
                'ajaxUrl' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('loadlink_admin_nonce')
            ]);
        }
    }
    
    /**
     * Display the dashboard page (delegated to Loadlink_Settings)
     */
    public function display_dashboard() {
        Loadlink_Settings::dashboard_page();
    }
    
    /**
     * Display the freight page (delegated to Loadlink_Admin_Freight)
     */
    public function display_freight_page() {
        $freight_admin = new Loadlink_Admin_Freight();
        $freight_admin->display_freight_page();
    }
    
}
