jQuery(document).ready(function($) {
    'use strict';
    
    // Initialize order actions
    initOrderActions();
    
    function initOrderActions() {
        // Add View Freight Details button to order page
        addFreightDetailsButton();
        
        // Handle modal interactions
        $(document).on('click', '.loadlink-view-freight-btn', function(e) {
            e.preventDefault();
            showFreightDetailsModal();
        });
        
        // Close modal handlers
        $(document).on('click', '.loadlink-order-modal-close', function() {
            closeFreightDetailsModal();
        });
        
        $(document).on('click', '.loadlink-order-modal', function(e) {
            if (e.target === this) {
                closeFreightDetailsModal();
            }
        });
        
        // Close modal with Escape key
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape' && $('.loadlink-order-modal').is(':visible')) {
                closeFreightDetailsModal();
            }
        });
    }
    
    function addFreightDetailsButton() {
        // Check if we have freight data
        if (!loadlinkOrderActions.freightId) {
            return;
        }
        
        // Add button to order actions area
        var $orderActions = $('.order_actions');
        if ($orderActions.length) {
            var freightButton = $('<a href="#" class="button loadlink-view-freight-btn">View Freight Details</a>');
            $orderActions.append(freightButton);
        }
        
        // Also add to order data meta box
        var $orderData = $('#order_data .order_data_column');
        if ($orderData.length) {
            var freightInfo = $('<div class="loadlink-freight-info" style="margin: 10px 0; padding: 10px; background: #f9f9f9; border: 1px solid #e1e1e1; border-radius: 4px;">');
            freightInfo.append('<strong>Loadlink Freight ID:</strong> ' + loadlinkOrderActions.freightId + '<br>');
            freightInfo.append('<a href="#" class="loadlink-view-freight-btn">View Full Freight Details</a>');
            $orderData.first().append(freightInfo);
        }
    }
    
    function showFreightDetailsModal() {
        // Create modal if it doesn't exist
        if ($('.loadlink-order-modal').length === 0) {
            createFreightDetailsModal();
        }
        
        var modal = $('.loadlink-order-modal');
        var detailsContainer = $('.loadlink-order-modal-body');
        
        // Show modal
        modal.show();
        detailsContainer.html('<div class="loadlink-loading">Loading freight details...</div>');
        
        // Make AJAX request
        $.ajax({
            url: loadlinkOrderActions.ajaxUrl,
            type: 'POST',
            data: {
                action: 'loadlink_get_order_freight_details',
                order_id: loadlinkOrderActions.orderId,
                freight_id: loadlinkOrderActions.freightId,
                nonce: loadlinkOrderActions.nonce
            },
            success: function(response) {
                if (response.success) {
                    detailsContainer.html(response.data);
                } else {
                    detailsContainer.html('<div class="loadlink-error">Error loading freight details: ' + response.data + '</div>');
                }
            },
            error: function(xhr, status, error) {
                detailsContainer.html('<div class="loadlink-error">Error loading freight details: ' + error + '</div>');
            }
        });
    }
    
    function createFreightDetailsModal() {
        var modalHtml = `
            <div class="loadlink-order-modal" style="display: none;">
                <div class="loadlink-order-modal-content">
                    <div class="loadlink-order-modal-header">
                        <h2>Freight Details</h2>
                        <span class="loadlink-order-modal-close">&times;</span>
                    </div>
                    <div class="loadlink-order-modal-body">
                        <div class="loadlink-loading">Loading...</div>
                    </div>
                </div>
            </div>
        `;
        
        $('body').append(modalHtml);
    }
    
    function closeFreightDetailsModal() {
        $('.loadlink-order-modal').hide();
    }
});
