jQuery(document).ready(function($) {
    'use strict';
    
    // Initialize admin freight page
    initAdminFreight();
    
    function initAdminFreight() {
        // Handle per-page change
        $('#loadlink-per-page').on('change', function() {
            var perPage = $(this).val();
            var url = new URL(window.location);
            url.searchParams.set('per_page', perPage);
            url.searchParams.delete('paged'); // Reset to first page
            window.location.href = url.toString();
        });
        
        // Handle search
        var searchTimeout;
        $('#loadlink-search').on('input', function() {
            var searchTerm = $(this).val();
            clearTimeout(searchTimeout);
            
            searchTimeout = setTimeout(function() {
                var url = new URL(window.location);
                if (searchTerm) {
                    url.searchParams.set('s', searchTerm);
                } else {
                    url.searchParams.delete('s');
                }
                url.searchParams.delete('paged'); // Reset to first page
                window.location.href = url.toString();
            }, 500); // Debounce search
        });
        
        // Handle sorting
        $('.loadlink-sort-link').on('click', function(e) {
            e.preventDefault();
            var column = $(this).closest('th').data('column');
            var currentOrder = getUrlParameter('order');
            var currentOrderby = getUrlParameter('orderby');
            
            var newOrder = 'ASC';
            if (currentOrderby === column && currentOrder === 'ASC') {
                newOrder = 'DESC';
            }
            
            var url = new URL(window.location);
            url.searchParams.set('orderby', column);
            url.searchParams.set('order', newOrder);
            window.location.href = url.toString();
        });
        
        // Handle view details
        $('.loadlink-view-details').on('click', function(e) {
            e.preventDefault();
            var freightId = $(this).data('freight-id');
            var orderId = $(this).data('order-id');
            
            showFreightDetails(freightId, orderId);
        });
        
        // Handle create test freight data
        $('#loadlink-create-test-freight').on('click', function(e) {
            e.preventDefault();
            createTestFreightData();
        });
        
        // Handle create freight for individual order
        $(document).on('click', '.loadlink-create-freight', function(e) {
            e.preventDefault();
            var orderId = $(this).data('order-id');
            createFreightForOrder(orderId);
        });
        
        // Handle modal close
        $(document).on('click', '.loadlink-modal-close', function() {
            closeModal();
        });
        
        // Close modal when clicking outside
        $(document).on('click', '.loadlink-modal', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });
        
        // Close modal with Escape key
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape' && $('#loadlink-freight-modal').is(':visible')) {
                closeModal();
            }
        });
    }
    
    function showFreightDetails(freightId, orderId) {
        var modal = $('#loadlink-freight-modal');
        var detailsContainer = $('#loadlink-freight-details');
        
        // Show modal
        modal.show();
        detailsContainer.html('<div class="loadlink-loading">Loading...</div>');
        
        // Make AJAX request
        $.ajax({
            url: loadlinkAdmin.ajaxUrl,
            type: 'POST',
            data: {
                action: 'loadlink_get_freight_details',
                freight_id: freightId,
                order_id: orderId,
                nonce: loadlinkAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    detailsContainer.html(response.data);
                } else {
                    detailsContainer.html('<div class="loadlink-error">Error loading freight details: ' + response.data + '</div>');
                }
            },
            error: function(xhr, status, error) {
                detailsContainer.html('<div class="loadlink-error">Error loading freight details: ' + error + '</div>');
            }
        });
    }
    
    function closeModal() {
        $('#loadlink-freight-modal').hide();
    }
    
    function createTestFreightData() {
        if (!confirm('This will create test freight data for recent orders with Loadlink shipping. Continue?')) {
            return;
        }
        
        $.ajax({
            url: loadlinkAdmin.ajaxUrl,
            type: 'POST',
            data: {
                action: 'loadlink_create_test_freight',
                nonce: loadlinkAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data.message);
                    location.reload(); // Refresh the page to show new data
                } else {
                    alert('Error: ' + response.data);
                }
            },
            error: function(xhr, status, error) {
                alert('Error creating test freight data: ' + error);
            }
        });
    }
    
    function createFreightForOrder(orderId) {
        if (!confirm('Create freight data for this order?')) {
            return;
        }
        
        $.ajax({
            url: loadlinkAdmin.ajaxUrl,
            type: 'POST',
            data: {
                action: 'loadlink_create_freight_for_order',
                order_id: orderId,
                nonce: loadlinkAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    alert('Freight data created successfully!');
                    location.reload(); // Refresh the page to show updated data
                } else {
                    alert('Error: ' + response.data);
                }
            },
            error: function(xhr, status, error) {
                alert('Error creating freight data: ' + error);
            }
        });
    }
    
    function getUrlParameter(name) {
        var url = new URL(window.location);
        return url.searchParams.get(name);
    }
    
    // Update sort indicators
    function updateSortIndicators() {
        var currentOrderby = getUrlParameter('orderby') || 'date';
        var currentOrder = getUrlParameter('order') || 'DESC';
        
        $('.sort-indicator').text('↕');
        
        var currentTh = $('th[data-column="' + currentOrderby + '"]');
        var indicator = currentTh.find('.sort-indicator');
        
        if (currentOrder === 'ASC') {
            indicator.text('↑');
        } else {
            indicator.text('↓');
        }
    }
    
    // Initialize sort indicators
    updateSortIndicators();
});
