# Loadlink for WooCommerce - User Manual

Welcome to the Loadlink for WooCommerce User Manual. This guide helps you navigate, configure, and utilize the plugin to manage your parcel freight effectively.

## 1. Accessing the Plugin

After installation, a **"Loadlink Parcel Freight"** menu appears in your WordPress admin sidebar. It contains the following submenus:

*   **Dashboard**: The main overview and system health status.
*   **My Parcel Freight**: A history of your freight orders.
*   **Settings**: Configuration for API credentials and store defaults.
*   **About**: Plugin version information and feature list.
*   **Instructions**: A detailed step-by-step setup guide.
*   **Notices**: System notifications and alerts.

## 2. The Dashboard

The Dashboard is your command center.

### Sections:
*   **Banner**: Displays the plugin status.
*   **App Status**:
    *   **API Configuration**: Shows a green "Active" indicator when credentials are valid.
    *   **Freight Orders**: A counter of processed orders.
*   **Quick Actions**:
    *   **Configure Settings** (Orange button): Shortcut to the Settings page.
    *   **Setup Carrier Service**: Shortcut to help you start registering the carrier.
    *   **View Orders**: Shortcut to the "My Parcel Freight" page.
*   **Getting Started Guide**: A 3-step walk-through (Connect API, Register Carrier, Test & Launch).

---

## 3. Configuring Settings

Navigate to **Loadlink Parcel Freight > Settings**.

### API Configuration
*   **API URL**: The Loadlink API endpoint (default provided).
*   **API Key & Secret**: Enter your Loadlink public key and secret key (provided by your Loadlink representative).
*   **User ID**: Your specific Loadlink Account User ID.

### Store & Shipping Defaults
*   **Pickup/Delivery Building Type**: Set the default assumption for locations (e.g., "Residential" or "Commercial").
*   **Store Phone**: The phone number associated with the pickup location.
*   **Packaging Code**: The default packaging type code (e.g., `RX` for Box). *Note: You should also define dimensions on individual products.*

### Advanced Options
*   **Enable Logging**: detailed logs for troubleshooting (Saved to WooCommerce > Status > Logs).
*   **Mock API Mode**: Simulates API responses for testing without contacting the live server.
*   **Disable Throttling**: Bypasses rate-limiting checks (useful for heavy testing).

Click **"Save Changes"** to apply configurations.

---

## 4. Setup Instructions & Product Configuration

For a complete checklist, navigate to **Loadlink Parcel Freight > Instructions**.

### Critical Steps:
1.  **Product Setup**:
    *   Go to **Products > All Products**.
    *   Edit a product and select the **Shipping** tab.
    *   **Mandatory**: Enter **Weight** (kg) and **Dimensions** (L/W/H cm). Use the "Packaging Type" dropdown if available.
2.  **Shipping Zone**:
    *   Go to **WooCommerce > Settings > Shipping**.
    *   Add "Loadlink Live Rates" to your shipping zones to enable calculations at checkout.

---

## 5. Managing Freight Orders

Navigate to **Loadlink Parcel Freight > My Parcel Freight**.

### The Freight List
Displays all WooCommerce orders with Loadlink shipping data.
*   **Columns**: Freight ID, Name, Date, Pickup/Delivery summaries, and Order No.
*   **Search**: Find orders by ID or customer name.
*   **Create Test Freight Data**: A blue button at the top allows you to generate dummy freight records for testing display functionality.

### Viewing Details
Click the **"View Details"** button on any row to open a popup with the full freight manifest, including specific Service ID and addresses.

---

## 6. Managing Individual Orders

You can also access details from the standard WooCommerce order list:
1.  Go to **WooCommerce > Orders**.
2.  Click an order.
3.  Use the **"Order actions"** dropdown on the right: select **"View Freight Details"** and click **Update**.

---

## 7. Troubleshooting

*   **"API Configuration Checks"**: If the status on the Dashboard is not "Active", re-check your API Key and Secret for whitespace errors.
*   **"No Shipping Options"**: Ensure your products have weights and dimensions set. The API requires these to calculate a quote.
*   **Debug Logs**: Enable logging in Settings to see specific API error messages (like "Invalid Postcode").

For support, visit the **About** page for links to Loadlink documentation.
