# Loadlink WooCommerce Plugin - Technical Feature Documentation

This document provides a comprehensive technical overview of the Loadlink WooCommerce plugin. It details the architecture, feature implementations, core files, and data flows, serving as a guide for developers and maintainers.

## 1. Shipping Rate Calculation (Live Rates)

### Overview
The plugin intercepts the WooCommerce shipping calculation process to fetch real-time freight rates from the Loadlink API.

### Technical Implementation
*   **Trigger:** The `calculate_shipping` method in `includes/class-loadlink-shipping-method.php` is triggered by WooCommerce's shipping API.
*   **Controller:** `Loadlink_Rates_Controller::get_rates($package)` acts as a middleman. It:
    *   Validates the address completeness.
    *   Hashes the package contents (`md5(serialize($package))`) to prevent duplicate API calls for the same payload within a short window (throttling).
    *   Builds the API payload, calculating total weight and volume.
*   **Client:** `Loadlink_Client::fetch_rates($payload)` performs the actual HTTP request.
    *   **Authentication:** Generates an HMAC-SHA256 signature using the API Key and Secret.
    *   **Address Normalization:** Converts full Australian state names (e.g., "Victoria") to codes ("VIC") using `normalize_state()` to ensure API compatibility.
    *   **Caching:** Implements a multi-layer cache (Transient API & Session) to reduce latency and API usage.

### Core Files
*   `includes/class-loadlink-shipping-method.php`: `WT_Shipping_Method` extension.
*   `includes/class-loadlink-rates-controller.php`: Rate logic controller.
*   `includes/class-loadlink-client.php`: API client wrapper.

---

## 2. Order Processing & Freight Booking

### Overview
Automates the confirmation of a freight booking with Loadlink when a customer places an order.

### Technical Implementation
*   **Triggers:**
    *   `woocommerce_checkout_order_processed` (Classic Checkout)
    *   `woocommerce_store_api_checkout_order_processed` (Blocks Checkout)
    *   `woocommerce_payment_complete` (Payment gateway callback)
*   **Data Capture:**
    *   During checkout, the selected "Service Quote ID" (specific to the chosen shipping option) and the "Freight ID" (generated during the rate quote) are temporarily stored in the WC Session.
    *   Upon order creation, this data is moved from the Session to Order Meta (`_loadlink_freight_id`, `_loadlink_service_quote_id`).
*   **Confirmation Request:** `Loadlink_Order_Confirmation::confirm_freight_order` constructs a confirmation payload containing the full pickup and delivery details and sends it to the Loadlink API.
*   **Response Handling:** If successful, `_loadlink_confirmation_status` is set to 'confirmed' and the confirmation ID is saved.

### Core Files
*   `includes/class-loadlink-order-confirmation.php`: Main orchestration class.
*   `includes/class-loadlink-data-mapper-order.php`: Maps WC Order objects to Loadlink API JSON structure.

---

## 3. Checkout Compatibility (Classic & Blocks)

### Overview
Ensures full functionality across both the legacy shortcode checkout (`[woocommerce_checkout]`) and the modern Gutenberg Blocks checkout (`wp:woocommerce/checkout`).

### Technical Implementation
#### Classic Checkout
*   Relies on standard `$_POST` data processing and `WC()->session`.
*   Field hooks: `woocommerce_checkout_fields` filters for adding phone and building type fields.

#### Blocks Checkout
*   **Challenge:** Blocks checkout uses the Store API, which functions differently from standard form posts.
*   **Solution:**
    *   **State Normalization:** Logic in `Loadlink_Client` handles full state names often returned by Blocks address forms.
    *   **Frontend Integration:** `assets/loadlink-checkout.js` detects the Blocks environment and injects necessary UI listeners.
    *   **Session Persistence:** `Loadlink_Order_Confirmation::save_freight_data_blocks` handles the specific hook `woocommerce_store_api_checkout_update_order_meta` to ensure session data is correctly persisted to the order before the session is cleared.
    *   **Fallback:** If session data is missing, the system attempts to re-fetch freight data from the API during the order creation event.

### Core Files
*   `BLOCKS_CHECKOUT_COMPATIBILITY.md`: Detailed architecture node.
*   `includes/class-loadlink-plugin.php`: Registers checkout assets and fields.
*   `assets/loadlink-checkout.js`: Frontend compatibility script.

---

## 4. Admin Dashboard & Settings

### Overview
A custom administrative interface for configuration, monitoring, and testing.

### Technical Implementation
*   **Settings Page:** Located at `WooCommerce > Settings > Shipping > Loadlink`.
*   **Custom Dashboard:** A dedicated page "Loadlink Parcel Freight" (`admin.php?page=loadlink-dashboard`) rendering custom HTML/CSS widgets.
    *   Status indicators check for valid API credentials.
    *   "Freight Orders" count queries the `wp_postmeta` table for orders with `_loadlink_freight_id`.
*   **API Tester:** An AJAX-driven tool (`Loadlink_Settings::test_api_ajax`) allowing admins to simulate a rate request with custom dimensions and destination, viewing the raw JSON response.
*   **Banner Layout:** Uses a hidden `h1.screen-reader-text` and `hr.wp-header-end` hack to force WordPress admin notices to render *above* the custom dashboard banner.

### Core Files
*   `includes/class-loadlink-settings.php`: Settings logic and API tester.
*   `includes/class-loadlink-admin-dashboard.php`: Dashboard widget logic.
*   `assets/admin-dashboard.css`: Custom styling.

---

## 5. Order Actions & Data Management

### Overview
Enhances the Order Details view for administrators.

### Technical Implementation
*   **Freight Data Meta:** Stores the full JSON blob of the freight data in `_loadlink_freight_data` order meta.
*   **Order Actions:** Registers a custom hook `woocommerce_order_actions` to add a "View Freight Details" button in the order edit screen.
*   **Details Modal:** Clicking the action triggers an AJAX request (`loadlink_get_order_freight_details`) which returns a formatted HTML view of the stored payload and response, displayed in a modal.

### Core Files
*   `includes/class-loadlink-order-actions.php`: Registers actions and AJAX handlers.
*   `includes/class-loadlink-admin-freight.php`: Logic for the "My Parcel Freight" list table.

---

## 6. Logging & Debugging

### Overview
A robust logging system isolating Loadlink-specific events from general WooCommerce logs.

### Technical Implementation
*   **Logger:** Uses `WC_Logger` with a specific source handle (`loadlink`).
*   **Log Locations:** Logs are accessible via **WooCommerce > Status > Logs** (select `loadlink-...` from dropdown).
*   **Events Logged:**
    *   Raw API request/response payloads (critical for debugging rate issues).
    *   Address validation failures (e.g., missing postcode).
    *   Freight confirmation success/failure.
    *   Session cache hits/misses.

### Core Files
*   `includes/class-loadlink-logger.php`: Static wrapper for logging calls.

---

## 7. Key Hooks & Filters

A reference of the primary hooks used by the plugin:

| Hook Name | Type | Purpose |
| :--- | :--- | :--- |
| `woocommerce_shipping_methods` | Filter | Register `Loadlink_Shipping_Method` class. |
| `woocommerce_checkout_order_processed` | Action | Trigger freight confirmation (Classic). |
| `woocommerce_store_api_checkout_order_processed` | Action | Trigger freight confirmation (Blocks). |
| `woocommerce_checkout_fields` | Filter | Inject "Dropoff Building Type" and "Phone" fields. |
| `woocommerce_product_options_dimensions` | Action | Add "Packaging Type" field to Product data tab. |
