---
description: How to deploy the Loadlink WooCommerce Plugin
---

# Deploy Payload WooCommerce Plugin

This workflow outlines the steps to prepare, package, and deploy the Loadlink WooCommerce plugin.

## 1. Preparation and Versioning

Before deploying, ensure the version number is updated.

1.  Open `woocommerce-loadlink.php`.
2.  Update the `Version:` header and the `LOADLINK_VERSION` constant to the new version number.
3.  Check `includes/class-loadlink-plugin.php` if it contains any version constants.

## 2. Code Cleanup

Remove or exclude any temporary debug or test files before packaging.
Common files to exclude/ignore:
- `.agent/`
- `*.md` (Documentation)
- `test-*.php` (Test scripts)
- `debug-*.php` (Debug scripts)
- `.DS_Store` or `Thumbs.db`

## 3. Packaging for WordPress

To create a installable ZIP file for WordPress:

### Option A: Manual Zipping (Windows)
1.  Navigate to the parent directory of `loadlink-woocommerce`.
2.  Right-click the `loadlink-woocommerce` folder.
3.  Select **Send to > Compressed (zipped) folder**.
4.  Rename the zip to `loadlink-woocommerce.zip`.

*Note: Ensure you don't include the hidden `.git` folder or test scripts in the zip if possible.*

### Option B: PowerShell Command (creates clean build)

Run this command in the terminal from the project root to create a clean zip (requires PowerShell 5+):

```powershell
$version = "1.0.0" # Change this to match your release
$zipName = "loadlink-woocommerce-$version.zip"
$exclude = @(".git", ".agent", "*.md", "test-*.php", "debug-*.php", "*.zip")

Compress-Archive -Path . -DestinationPath $zipName -CompressionLevel Optimal -Update
```

## 4. Installing on WooCommerce

1.  Log in to the WordPress Admin (`/wp-admin`).
2.  Go to **Plugins > Add New**.
3.  Click **Upload Plugin**.
4.  Choose the `loadlink-woocommerce.zip` file you created.
5.  Click **Install Now**.
6.  If updating, confirm replacing the existing version.
